#include "Texture.h"

#include "BMP.h"
#include "genTex.h"

CTexture *CTexture::m_Singleton=NULL;

CTexture::CTexture(){}

CTexture::~CTexture()
{
    map<string,GLuint>::iterator it;
    for(it=vectTex.begin();it!=vectTex.end();it++)glDeleteTextures(1,&(it->second));
}

CTexture *CTexture::GetInstance()
{
    if(!m_Singleton)m_Singleton=new CTexture();
    return m_Singleton;
}

void CTexture::Kill()
{
    if(m_Singleton)
    {
        delete m_Singleton;
        m_Singleton=NULL;
    }
}

GLuint CTexture::getTexture(char *filename,bool colorKey,unsigned char trsp,unsigned char r,unsigned char g,unsigned char b,bool rept)
{
    if(!filename || !(*filename))return 0xFFFFFFFF;
    
    GLuint res;
    string fnm(filename);
    map<string,GLuint>::iterator it=vectTex.find(fnm);
    
    if(it==vectTex.end())
    {
        char *tt=(filename+fnm.length()-4);
        if(strcmp(tt,".bmp")==0)res=makeTex2D_BMP(filename,colorKey,trsp,r,g,b,rept);
        else if(fnm=="LASER_BLUE_TEX_PROC")res=genLaserTex(32,32,0.0,0.0,1.0,0.0,1.0);
        else if(fnm=="LASER_RED_TEX_PROC")res=genLaserTex(32,32,1.0,0.0,0.0,0.0,1.0);
        else if(fnm=="LASER_GREEN_TEX_PROC")res=genLaserTex(32,32,0.0,1.0,0.0,0.0,1.0);
        else if(fnm=="LASER_CYAN_TEX_PROC")res=genLaserTex(32,32,0.0,1.0,1.0,0.0,1.0);
        else if(fnm=="LASER_YELLOW_TEX_PROC")res=genLaserTex(32,32,1.0,1.0,0.0,0.0,1.0);
        else if(fnm=="LIGHT_REDBLUE_TEX_PROC")res=genLightTex(32,32,0.0,0.0,1.0,0.8,0.3,0.3,0.0,1.0);//(32,32,0.5,0.0,0.8,1.0,0.1,0.1,0.0,1.0);
        else if(fnm=="LIGHT_ORANGE_TEX_PROC")res=genLightTex(32,32,1.0,0.8,0.0,0.8,0.2,0.2,0.0,0.6);
        else if(fnm=="SMOKE_TEX_PROC")res=genLightTex(32,32,0.4,0.4,0.4,1.0,1.0,1.0,-0.1,0.5);
        else res=0xFFFFFFFF;
        
        if(res<0xFFFFFFFF)vectTex[fnm]=res;
    }
    else res=it->second;
    
    return res;
}

GLuint CTexture::getTexture3D(char *filename,int nbTex,char *filenames[])
{
    GLuint res;
    string fnm(filename);
    map<string,GLuint>::iterator it=vectTex.find(fnm);
    
    if(it==vectTex.end())
    {
        char *tt=(filename+fnm.length()-4);
        if(strcmp(tt,".bmp")==0)res=makeTex3D_BMP(nbTex,filenames);
        else res=0xFFFFFFFF;
        
        if(res<0xFFFFFFFF)vectTex[fnm]=res;
    }
    else res=it->second;
    
    return res;
}
